<!-------------------------------------- Contact Page --------------------------------------->
<div id="story" class="light-wrapper wrapper">
    <div class="container-fluid inner">
        <div class="row">
            <div id="loginForm" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="form-block">
                    <ul class="list-group" style="list-style: none;">
                        <?php echo $template['partials']['flash_messages'] ?>
                        <li class="list-group-item text-center"><h3 class="lead">Please login with your credential</h3></li>
                        <?php echo form_open('user/validate', array('class' => 'form-horizontal', 'id' => 'loginVerificationForm')) ?>
                        <li class="list-group-item">
                            <div class="block">
                                <div id='ShowLoginVerificationFailedMessage'></div>
                                <div class="form-group">
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-12 control-label" style='padding-top: 20px;color: #000000;'>Email</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                                        <input type='text' class="form-control" name='email'>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-12 control-label" style='padding-top: 20px; color: #000000;'>Password</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                                        <input type='password' class="form-control" name='password'>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li class="list-group-item"> <input class="btn btn-large btn-danger" style="width: 100%; height: 45px; margin: 0 auto;" type="submit" name="submit_form" tabindex="4" value="<?php echo $this->lang->line('gkpos_numpad_key_enter') ?>" onclick="loginVerification('loginVerificationForm', 'loginVerificationFormError')"></li>
                        <?php echo form_close() ?>
                        <li><ul id="loginVerificationFormError" class="error_message_box list-group" style="list-style: none;"></ul></li>
                        <li class="list-group-item" style="padding: 10px 4px 30px 4px;">
                            <div id="forgetPasswordFormLoader" class="pull-left"><a href="javascript:void(0)" class="text-left">Forget Password</a></div>
                            <div id="registerFormLoader" class="pull-right" ><a href="javascript:void(0)" class="text-right">Yet not a member, Register</a></div>
                        </li>
                    </ul>
                </div>
            </div> 
            <div class="clearfix"></div>
            <div id="registrationForm" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="display: none;">
                <div class="form-block">
                    <ul id="userRegistrationFormError" class="error_message_box list-group text-center"></ul>
                    <ul class="list-group">
                        <li class="list-group-item text-center"><h3 class="lead" style="font-size: 12px;">Create Your <?php echo ' ' . $this->config->item('gk_name') . ' ' ?>Online Order Account</h3></li>
                        <li class="list-group-item">
                            <?php echo form_open('user/register', array('class' => 'form-horizontal', 'id' => 'userRegistrationForm')) ?>
                            <div class='block'>
                                <div class="block-header">Basic Information</div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;''>Name</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='name'>
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;''>Contact No</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='phone'>
                                    </div>
                                </div>
                            </div>
                            <div class='block'>
                                <div class="block-header">Location Details</div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Postal Code</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='postcode' style='text-transform: uppercase'>
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Street Address</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='street'>
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>City</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='city' id="city">
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>Country</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='country' id="country">
                                    </div>
                                </div>
                            </div>
                            <div class='block'>
                                <div class="block-header">Account Credential</div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>Email</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='text' class="form-control input-sm" name='email'>
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>Password</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='password' class="form-control input-sm" name='password' id='userPassword'>
                                    </div>
                                </div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>Confirmed Password</label>
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                        <input type='password' class="form-control input-sm" name ='confirm_password' id='confirmPassword'>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <div class="form-group" style='margin: 10px 0px 10px 0px'>
                                <input class="btn btn-large btn-danger" style="width: 100%; height: 40px; margin: 0 auto;" type="submit" name="submit_form" tabindex="4" value="<?php echo $this->lang->line('gkpos_numpad_key_enter') ?>" onclick="register('userRegistrationForm', 'userRegistrationFormError')">
                            </div>
                        </li>
                        <li class="list-group-item">
                            <div style="cursor: pointer; margin: 0px; padding: 10px;" id='loginFormLoader'><a href="javascript:void(0)">If you are a registered member,Please click here to login</a></div>
                        </li>
                        <?php echo form_close() ?>
                    </ul>

                </div>
            </div> 
            <div class="clearfix"></div>
            <div id="forgetPasswordForm" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="display: none;">
                <div class="form-block">
                    <ul class="list-group">
                        <li class="list-group-item text-center"><h3 class="lead" style="font-size: 12px;">Please Enter Your Email Address And Press Enter</h3></li>
                        <?php echo form_open('user/forgetpassword', array('class' => 'form-horizontal', 'id' => 'resetPasswordForm')) ?>
                        <li class="list-group-item">
                            <div class="block"> 
                                <div id='ShowVerificationFailedMessage'></div>
                                <div class="form-group" style='margin-bottom: 0px'>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type='text' class="form-control input-sm" name='rocovery_email'>
                                    </div>
                                </div>
                                <ul id="resetPasswordFormError" class="error_message_box"></ul>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <div class="form-group" style='margin: 10px 0px 10px 0px'>
                                <input class="btn btn-large btn-danger" style="width: 100%; height: 40px; margin: 0 auto;" type="submit" name="submit_form" tabindex="4" value="<?php echo $this->lang->line('gkpos_numpad_key_enter') ?>" onclick="resetPassword('resetPasswordForm', 'resetPasswordFormError')">
                            </div>
                        </li>
                        <?php echo form_close() ?>
                    </ul>
                </div>
            </div> 
        </div>
    </div>
</div>
<!-------------------------------------- End Contact Page ----------------------------------->
<script type="text/javascript">
    $(document).ready(function () {
        var register = '<?php echo $register ?>';
        if (register == 'register') {
            $('#loginForm').hide('slow');
            $('#forgetPasswordForm').hide('slow');
            $('#registrationForm').show('slow');
        }
        $('#registerFormLoader').click(function () {
            $('#loginForm').hide('slow');
            $('#forgetPasswordForm').hide('slow');
            $('#registrationForm').show('slow');
        });

        $('#loginFormLoader').click(function () {
            $('#registrationForm').hide('slow');
            $('#forgetPasswordForm').hide('slow');
            $('#loginForm').show('slow');

        });
        $('#forgetPasswordFormLoader').click(function () {
            $('#registrationForm').hide('slow');
            $('#loginForm').hide('slow');
            $('#forgetPasswordForm').show('slow');

        });
        $("#country").autocomplete({
            delay: 0,
            source: '<?php echo site_url('user/get_country') ?>',
            minLength: 1
        });
        $("#city").autocomplete({
            delay: 0,
            source: '<?php echo site_url('user/get_city') ?>',
            minLength: 1
        });
    });
    function register(formId, error_message_box) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            location.replace('<?php echo site_url('user') ?>');
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            errorLabelContainer: "#" + error_message_box,
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
                $('.error_message_box').addClass('block');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {
                    lettersonly: true,
                    required: true
                },
                phone: {
                    required: true,
                    phone: true
                },
                email: {
                    email: true,
                    required: true
                },
                password: {
                    //pwcheck: true,
                    required: true
                },
                confirm_password: {
                    equalTo: "#userPassword"
                },
                postcode: {
                    postcodeUK: true,
                    required: true
                },
                street: "required",
                city: "required"
            },
            messages: {
                name: "<?php echo $this->lang->line('gkpos_valid_name_required') ?>",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                email: "Please specify valid Email Address",
                password: "Password is a required field",
                confirm_password: "Confirmed Password does not match",
                postcode: "Postal code with UK format is required",
                street: "Please Provide your street address",
                city: "Your city is a required field"


            }
        });
    }
    function resetPassword(formId, error_message_box) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            location.replace('<?php echo site_url() ?>');
                        } else {
                            $("#ShowVerificationFailedMessage").html('');
                            $('#ShowVerificationFailedMessage').text(response.message);
                            $('#ShowVerificationFailedMessage').addClass('alert alert-dismissible alert-danger');
                        }
                    }
                });
            },
            errorClass: "has-error",
            errorLabelContainer: "#" + error_message_box,
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
                $('.error_message_box').addClass('block');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                rocovery_email: "required"
            },
            messages: {
                rocovery_email: "Please use only that email address registered here"
            }
        });
    }
    function loginVerification(formId, error_message_box) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            var checkoutLogin = '<?php $this->Site_Model->is_checkout_login() ? print true : print false ?>';
                            if (checkoutLogin) {
                                '<?php $this->Site_Model->clear_checkout_login() ?>';
                                location.replace('<?php echo site_url('onlineorder/checkout') ?>');
                            } else {
                                var hasCart = '<?php !$this->Site_Model->get_cart() ? print 'no' : print 'yes' ?>';
                                if (hasCart == 'yes') {
                                    location.replace('<?php echo site_url('onlineorder') ?>');
                                } else {
                                    location.replace('<?php echo site_url() ?>');
                                }
                            }
                        } else {
                            $("#ShowLoginVerificationFailedMessage").html('');
                            $('#ShowLoginVerificationFailedMessage').text(response.message);
                            $('#ShowLoginVerificationFailedMessage').addClass('alert alert-dismissible alert-danger');
                        }
                    }
                });
            },
            errorClass: "has-error",
            errorLabelContainer: "#" + error_message_box,
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
                $('.error_message_box').addClass('block');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                email: {
                    email: true,
                    required: true
                },
                password: {
                    required: true
                }
            },
            messages: {
                email: "Please use your registered email only",
                password: "Please specify your valid password"
            }
        });
    }
</script>
